// Copyright 2000 Macromedia, Inc. All rights reserved.
//*************** GLOBAL CONSTANTS *****************
var helpDoc = MM.HELP_objFlashText;
var TYPE_STR = "Flash Text";
var FILE_CONFIG_PATH = dw.getConfigurationPath();
var FILE_TEXT_TEMPLATE_PATH = FILE_CONFIG_PATH + "/Flash Objects/Flash Text/text template.swt";
var STYLE_EXT_STR = "swt";
var TYPE_PARAMETER = "dwType";
var YIELD_PATH = "../Shared/MM/Images/yield.gif";
var DEFAULT_SIZE = 30;
var MAX_FILE_LENGTH = 23;
//*************** GLOBAL VARIABLES *****************
// UI Elements
var MENU_FONTS, MENU_TARGET;
var TEXT_SIZE, TEXT_URL, TEXT_SAVE_AS;
var TEXTAREA_TEXT;
var CHECKBOX_FONT, CHECKBOX_SIZE;
var TEXT_TEXT_COLOR, TEXT_ROLLOVER_COLOR, TEXT_BG_COLOR;
var COLORP_TEXT, COLORP_ROLLOVER, COLORP_BG;
var IBTN_boldBtn, IBTN_italicBtn;
var IBTN_rightAlignBtn, IBTN_leftAlignBtn, IBTN_centerAlignBtn, IBTN_justifyAlignBtn;
var IBTN_GROUP_ALIGN;
var AREA_WARNING;
// other globals
var ARRAY_TARGET_STR = new Array("","_blank","_parent","_self","_top");
var REEDIT_SWF_PATH;
var URL_BROWSE;
var ALIGN_MAP = new Array();
var ALIGNMENT = new Array("left","right","center","justified");
var ALIGNMENT_BTNS = new Array("leftAlignBtn","rightAlignBtn","centerAlignBtn","justifyAlignBtn");
var FLAG_OVERWRITE = new Object();
FLAG_OVERWRITE.state = false;
FLAG_OVERWRITE.reEdit = false;
var FILE_CURRENT_DOC_PATH;
var WIDTH_PERCENT;
var HEIGHT_PERCENT;
var LAST_SIZE=DEFAULT_SIZE;
//******************* API **********************

function commandButtons()
{
   return new Array( BTN_OK,  "cmdOK(); "
           , BTN_Apply, "cmdApply();"
                   , BTN_Cancel, "cmdCancel();"
                   , BTN_Help, 'displayHelp()');
}

function cmdOK()
{
  var done = insertTextHTML();
  if (done)
    window.close();
}

function cmdApply()
{
 var filename = document.saveAsField.getAttribute("value");
 insertTextHTML();
 FLAG_OVERWRITE.state = true;
 FLAG_OVERWRITE.file = addExtention(filename, "swf");
//  var dom = dw.getDocumentDOM();
//  dom.insertHTML("test apply", true);
}

function cmdCancel()
{
  window.close();
}

function receiveArguments(swfPath)
{
  var fileName, fileObj;
  var dom = dw.getDocumentDOM('document');
  var sizeArray = SWFFile.getNaturalSize(swfPath);
  var widthHTML = getSelectedNodeAttr("WIDTH",dom);
  var heightHTML = getSelectedNodeAttr("HEIGHT",dom);
  FILE_CURRENT_DOC_PATH = dw.getDocumentPath("document");
  if (swfPath)
  {
    REEDIT_SWF_PATH = swfPath;
//    fileObj = new File(REEDIT_SWF_PATH);
//  fileName = fileObj.getName();
    FLAG_OVERWRITE.state = true;
  FLAG_OVERWRITE.reEdit = true;
//    FLAG_OVERWRITE.file = fileName;
  FLAG_OVERWRITE.file = absoluteToRelativeURL(swfPath, FILE_CURRENT_DOC_PATH,false);
  WIDTH_PERCENT = widthHTML/sizeArray[0];
    HEIGHT_PERCENT = heightHTML/sizeArray[1];
  }
}
//***************** LOCAL FUNCTIONS  ******************

function initializeUI()
{
  var fontArray, targetArray, docFramesArray, swfButtonParams;
  FILE_CURRENT_DOC_PATH = dw.getDocumentPath("document");
  MENU_FONTS = new ListControl("fontMenu");
  MENU_TARGET = new ListControl("targetMenu");
  fontArray = filterFonts(dw.getSystemFontList("TrueType"));
  if (!fontArray)
  {
    alert(MSG_NoFontsInstalled);
  window.close();
  return "";
  }
  else
    MENU_FONTS.setAll(fontArray,fontArray);
  docFramesArray = dw.getDocumentDOM().getFrameNames();
  targetArray = ARRAY_TARGET_STR;
  if (docFramesArray)
    targetArray = targetArray.concat(docFramesArray);
  MENU_TARGET.setAll(targetArray, targetArray);
  TEXT_SIZE = document.theForm.sizeField;
  TEXTAREA_TEXT = document.theForm.textInputField;
  TEXT_URL = document.theForm.linkField;
  TEXT_SAVE_AS = document.theForm.saveAsField;
  TEXT_TEXT_COLOR = document.theForm.textColorField;
  TEXT_ROLLOVER_COLOR = document.theForm.rolloverColorField;
  TEXT_BG_COLOR = document.theForm.bgColorField;
  COLORP_TEXT = document.theForm.textColorP;
  COLORP_ROLLOVER = document.theForm.rolloverColorP;
  COLORP_BG = document.theForm.bgColorP;
  CHECKBOX_FONT = document.theForm.fontCheckBox;
  CHECKBOX_SIZE = document.theForm.sizeCheckBox;
  IBTN_boldBtn = new ImageButton("boldBtn","IBTN_boldBtn","sSd");
  IBTN_italicBtn = new ImageButton("italicBtn","IBTN_italicBtn","sSd");
  IBTN_rightAlignBtn = new ImageButton("rightAlignBtn");
  IBTN_leftAlignBtn = new ImageButton("leftAlignBtn");
  IBTN_centerAlignBtn = new ImageButton("centerAlignBtn");
  IBTN_GROUP_ALIGN = new ImageButtonGroup(IBTN_rightAlignBtn, IBTN_leftAlignBtn, IBTN_centerAlignBtn);
  IBTN_GROUP_ALIGN.select('leftAlignBtn');

  for (var i=0; i< ALIGNMENT_BTNS.length; i++)
    ALIGN_MAP[ALIGNMENT_BTNS[i]] = ALIGNMENT[i];
  AREA_WARNING = document.theForm.warningMessage;
  if (REEDIT_SWF_PATH)
  {
//  REEDIT_SWF_PATH =File.getFullUrl(REEDIT_SWF_PATH, FILE_CURRENT_DOC_PATH);  // modify text does not pass in full path
    swfButtonParams = SWFFile.readFile(REEDIT_SWF_PATH);
    swfButtonParams.unshift("templatePath");
//    if (navigator.platform != "Win32")
    if (!hasDoubleByteChar(swfButtonParams[1]))
      swfButtonParams[1] = unescape(swfButtonParams[1]);
    if (swfButtonParams.length % 2 != 0) // if last parameter has no value array is odd
      swfButtonParams.push("");
    populateUI(swfButtonParams,absoluteToRelativeURL(REEDIT_SWF_PATH, FILE_CURRENT_DOC_PATH,true));
  }
  else
  {
    updateUI("fontMenu");
    TEXT_SAVE_AS.value = createUniqueFilename("text", getDocumentDir(FILE_CURRENT_DOC_PATH),MAX_FILE_LENGTH);
  }
  TEXTAREA_TEXT.focus();
  TEXTAREA_TEXT.select();
  return "";
}

function updateUI(itemName)
{
  var styleAttribute, replacementStr,browseURL, pattern, theLink, fontStyles,theFont;
  switch(itemName)
  {
    case "fontMenu":
  {
    if (CHECKBOX_FONT.checked == true)
    {
      theFont = MENU_FONTS.get();
      replacementStr = "font-family:" + theFont + ";";
      pattern = /font-family:.*;/ ;
      updateStyle(TEXTAREA_TEXT,pattern, replacementStr);
      (!hasDoubleByteChar(theFont)) ? IBTN_boldBtn.enable() : IBTN_boldBtn.disable();
//      fontStyles = dw.getFontStyles(theFont);
//      (fontStyles[0]==true) ? IBTN_boldBtn.enable() : IBTN_boldBtn.disable();
//      (fontStyles[1]==true) ? IBTN_italicBtn.enable() : IBTN_italicBtn.disable();
    }
    break;
  }
  case "boldBtn":
  {
//    theFont = MENU_FONTS.get();
//    fontStyles = dw.getFontStyles(theFont);
//    if (IBTN_boldBtn.value == true && fontStyles[2]==false)
//      IBTN_italicBtn.disable();
//    else if (fontStyles[1]==true)
//      IBTN_italicBtn.enable();
  }
  case "italicBtn":
  {
//    theFont = MENU_FONTS.get();
//    fontStyles = dw.getFontStyles(theFont);
//    if (IBTN_italicBtn.value == true && fontStyles[2]==false)
//      IBTN_boldBtn.disable();
//    else if (fontStyles[0]==true)
//      IBTN_boldBtn.enable();
  }
  case "sizeField":
  {
    if (!isInteger(TEXT_SIZE.value))
    {
      TEXT_SIZE.value = LAST_SIZE;
    }
    else
      LAST_SIZE = TEXT_SIZE.value
/*
    if (CHECKBOX_SIZE.checked == true)
    {
      replacementStr = "font-size:" + TEXT_SIZE.value + ";";
      pattern = /font-size:\s*\w*\s*;/ ;
      updateStyle(TEXTAREA_TEXT,pattern, replacementStr);
    }
*/
    break;
  }
  case "fontCheckBox":
  {
    if (CHECKBOX_FONT.checked == false)
    {
      replacementStr = "font-family:;";
      pattern = /font-family:.*;/;
      updateStyle(TEXTAREA_TEXT,pattern, replacementStr);
    }
    else
      updateUI("fontMenu")
    break;
  }
/*  case "sizeCheckBox":
  {
    if (CHECKBOX_SIZE.checked == false)
    {
      replacementStr = "font-size:;";
      pattern = /font-size:\s*\w*\s*;/ ;
      updateStyle(TEXTAREA_TEXT,pattern, replacementStr);
    }
    else
      updateUI("sizeField");
    break;
  }
*/
  case "linkField":
  {
    theLink = TEXT_URL.value;
    if (isSiteRelative(theLink))
      AREA_WARNING.innerHTML = createWarningMsgHTML(MSG_SiteRelLinkWarning, YIELD_PATH);
    else if (isDocRel(theLink))
      AREA_WARNING.innerHTML = createWarningMsgHTML(MSG_DocRelLinkWarning, YIELD_PATH);
    else if (theLink.indexOf("file:///")!=-1)
      AREA_WARNING.innerHTML = createWarningMsgHTML(MSG_LocalURLLinkWarning, YIELD_PATH);
    else
      AREA_WARNING.innerHTML = "";
    break;
  }
  case "linkButton":
  {
    browseURL = dreamweaver.browseForFileURL("select",LABEL_Select, false, true);
    if (browseURL)
      TEXT_URL.setAttribute("value", browseURL);
    updateUI("linkField");
    break;
  }
  case "saveAsButton":
  {
//    browseURL = dreamweaver.browseForFolderURL(LABEL_SelectFolder);
    browseURL = dreamweaver.browseForFileURL("save",LABEL_Select, false, true);
    browseURL = absoluteToRelativeURL(browseURL, FILE_CURRENT_DOC_PATH,false);
    if (browseURL)
      TEXT_SAVE_AS.setAttribute("value", browseURL);
    break;
  }
  case "textColorP":
  {
    updateColorPicker("colorPicker", COLORP_TEXT, TEXT_TEXT_COLOR);
    if (COLORP_TEXT.value == "")
      TEXT_TEXT_COLOR.setAttribute("value","#000000");
  }
    case "textColorField":
  {
    updateColorPicker("colorField", COLORP_TEXT, TEXT_TEXT_COLOR);
//    replacementStr = "color:" + COLORP_TEXT.value + ";";
//    pattern = /color:\s*\W*\w*\s*;/ ;
//    updateStyle(TEXTAREA_TEXT,pattern, replacementStr);
    if (COLORP_TEXT.value == "")
    {
      TEXT_TEXT_COLOR.setAttribute("value","#000000");
    updateColorPicker("colorField", COLORP_TEXT, TEXT_TEXT_COLOR);
    }
    break;
  }
  case "rolloverColorP":
    updateColorPicker("colorPicker", COLORP_ROLLOVER, TEXT_ROLLOVER_COLOR);
    case "rolloverColorField":
    updateColorPicker("colorField", COLORP_ROLLOVER, TEXT_ROLLOVER_COLOR);
  case "bgColorP":
    updateColorPicker("colorPicker", COLORP_BG, TEXT_BG_COLOR);
    case "bgColorField":
    updateColorPicker("colorField", COLORP_BG, TEXT_BG_COLOR);
  }
}

// populates UI when re-editing
function populateUI(paramArray, fileName)
{
  var updateArray = new Array("fontMenu","sizeField","textColorP","rolloverColorP","bgColorP","linkField");
  var theTarget = getValueFromParameters("window",paramArray);
  var theFont = getValueFromParameters("font",paramArray);
  var theLink = getValueFromParameters("url",paramArray);
  var docDOM = dw.getDocumentDOM('document');
  var bgcolor = getSelectedNodeAttr("BGCOLOR",docDOM);
  if (!MENU_FONTS.pickValue(theFont))
  {
    if (!confirm(errMsg(MSG_FontDoesNotExist,theFont)))
    window.close();
  }
//  TEXT_SIZE.value = (getValueFromParameters("size",paramArray)/72);
  TEXT_SIZE.value = (getValueFromParameters("size",paramArray)/20);
  if (getValueFromParameters("bold",paramArray)=="true")
    IBTN_boldBtn.setValue(true);
  if (getValueFromParameters("italic",paramArray)=="true")
    IBTN_italicBtn.setValue(true);
  // ** do alignment
  COLORP_TEXT.value = getValueFromParameters("color",paramArray);
  COLORP_ROLLOVER.value = getValueFromParameters("rollovercolor",paramArray);
//  COLORP_BG.value = getValueFromParameters("bgcolor",paramArray);
  COLORP_BG.value = bgcolor;
  TEXTAREA_TEXT.value = getValueFromParameters("text",paramArray);
  TEXT_URL.value = (theLink == "n/a") ? "" : theLink ;
  TEXT_SAVE_AS.value = fileName;
  if (!MENU_TARGET.pickValue(theTarget))
  {
    if (!confirm(errMsg(MSG_FrameNotFound, theTarget)))
      window.close();
  }
  for (var i=0; i<ALIGNMENT.length; i++)
  {
    align = getValueFromParameters("alignment",paramArray);
    if (align == ALIGNMENT[i])
    IBTN_GROUP_ALIGN.select(ALIGNMENT_BTNS[i]);
  }
  for (var i=0; i< updateArray.length; i++)
    updateUI(updateArray[i]);
}

function insertTextHTML()
{
  var data, outputFilePath, canCreateFile=false;
  var success=false, createFileMsg;
  var theLink = TEXT_URL.value;
  var fileName = TEXT_SAVE_AS.value;
  var dom = dw.getDocumentDOM();
  var selectedNode,wasPlaying, temp1, temp2;

  if (dom.canStopPlugin())
  {
    dom.stopPlugin();
  wasPlaying = true;
  }
  if (fileName.charAt(0) == " ")
  {
    alert(MSG_FilenameStartWithSpace);
  return false;
  }
  if (TEXTAREA_TEXT.value == "")
  {
    alert(MSG_PleaseEnterText);
  return false;
  }
  if (!fileName)
    alert(MSG_SaveAsFieldIsEmpty);
  else if ((outputFilePath = resolveFilePath(fileName,FILE_CURRENT_DOC_PATH,"swf")) == "")
    alert(errMsg(MSG_InvalidFileName,fileName));
  else
  {
    outputFilePath = truncateFileName(MAX_FILE_LENGTH, outputFilePath);
    if (!checkLink(theLink,outputFilePath,FILE_CURRENT_DOC_PATH))
      return false;
  if (DWfile.exists(outputFilePath) && DWfile.getAttributes(outputFilePath)=="R")
  {
    alert(errMsg(MSG_ReadOnlyFile,outputFilePath));
    return false;
  }
  if (!DWfile.exists(outputFilePath) || (FLAG_OVERWRITE.state == true && FLAG_OVERWRITE.file == addExtention(fileName, "swf")))
    canCreateFile=true;
  else if (confirm(errMsg(MSG_FileAlreadyExists, outputFilePath)))
    canCreateFile=true;
  if (canCreateFile==true)
  {
    if (TEXTAREA_TEXT.value.length > 1024 && !confirm(MSG_ExceedCharacterLimit))
      return false;
    data = generateData();
      MM.setBusyCursor();
    if (navigator.platform == "Win32")
      createFileMsg = SWFFile.createFile(FILE_TEXT_TEMPLATE_PATH,data,outputFilePath);
    else{
      temp1 = (hasDoubleByteChar(FILE_TEXT_TEMPLATE_PATH)) ?   FILE_TEXT_TEMPLATE_PATH : escape(FILE_TEXT_TEMPLATE_PATH);   // escape = high ascii bug on mac
      temp2 = (hasDoubleByteChar(outputFilePath)) ?   outputFilePath : escape(outputFilePath);
      createFileMsg = SWFFile.createFile(temp1,data,temp2);
    }
    MM.clearBusyCursor();
      if (createFileMsg=="noError")
    {
      if (!FLAG_OVERWRITE.reEdit)
      dom.insertHTML(createFlashHTML(outputFilePath,isDocRel(theLink)), FLAG_OVERWRITE.state);
    else
    {
      selectedNode = dom.getSelectedNode();
      editTextAttribute(outputFilePath,selectedNode);
// **** next line is a hack that needs to be removed when setSelectedNode bug fixed
      selectedNode.outerHTML = selectedNode.outerHTML;
//      dom.setSelectedNode(selectedNode);
    }
    dom.notifyFlashObjectChanged();
    success = true;
    }
    else
    {
      alert(generatorErrorMsg(createFileMsg,fileName));
    }
  }
  }
  if (wasPlaying)
    dom.playPlugin();
  return success;
}

function generateData()
{
  var retVal = new Array();
  var theLink = TEXT_URL.value;
  var theTarget = MENU_TARGET.get();
  var rolloverColor = TEXT_ROLLOVER_COLOR.value;
  var theText = TEXTAREA_TEXT.value;
  retVal[0] = TYPE_PARAMETER;
  retVal[1] = TYPE_STR;
  retVal[2] = "text";
  if (theText.length > 1024)
    retVal[3] = theText.substr(0,1024);
  else
    retVal[3] = theText;
  retVal[4] = "color";
  retVal[5] = TEXT_TEXT_COLOR.value;
  retVal[6] = "font";
  retVal[7] = MENU_FONTS.get();
  retVal[8] = "size";
  retVal[9] = convertPtToTwip(TEXT_SIZE.value);
  retVal[10] = "url";
  retVal[11] = (theLink) ? theLink : "n/a";
  retVal[12] = "window";
  retVal[13] = (theTarget) ? theTarget : "_self";
  retVal[14] = "rollovercolor";
  retVal[15] = (rolloverColor) ? rolloverColor : "none";
  retVal[16] = "shrinkwrap";
  retVal[17] = true;
  retVal[18] = "alignment";
  retVal[19] = ALIGN_MAP[IBTN_GROUP_ALIGN.getSelectedButtonName()];
  retVal[20] = "bold";
  retVal[21] = IBTN_boldBtn.value;
  retVal[22] = "italic";
  retVal[23] = IBTN_italicBtn.value;
//  retVal[24] = "bgcolor";
//  retVal[25] = TEXT_BG_COLOR.value;
  return retVal;
}

function createFlashHTML(swfURL, docRelLink)
{
  var retVal= new Array();
  var baseValue = ".";
  var sizeArray = SWFFile.getNaturalSize(swfURL);
  var width, height;
  var bgcolor = document.bgColorField.value;
  var docRelURL = absoluteToRelativeURL(swfURL, FILE_CURRENT_DOC_PATH,true);
  if (sizeArray)
  {
    width = sizeArray[0];
    height = sizeArray[1];
  }
  else
  {
    width = 32;
  height = 32;
  }
  retVal.push('<OBJECT CLASSID="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"');
  retVal.push(' CODEBASE="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=4,0,2,0"');
  retVal.push(' WIDTH="' + width + '" HEIGHT="'+ height + '">\n');
  retVal.push('<PARAM NAME=movie VALUE="' + docRelURL + '"> <PARAM NAME=quality VALUE=high>\n' );
  if (docRelLink) // chould check to see if link if doc relative
    retVal.push('<PARAM NAME="BASE" VALUE="' + baseValue + '">\n');
  retVal.push('<PARAM NAME="BGCOLOR" VALUE="' + bgcolor + '">\n');
  retVal.push('<param name="SCALE" value="exactfit">\n');
  retVal.push('<EMBED SRC="' + docRelURL +'"');
  if (docRelLink)
    retVal.push( ' BASE="' + baseValue+ '" ');
  retVal.push(   ' quality=high PLUGINSPAGE="http://www.macromedia.com/shockwave/download/index.cgi?P1_Prod_Version=ShockwaveFlash" ' +
         'TYPE="application/x-shockwave-flash" SCALE="exactfit" ');
  retVal.push('WIDTH="' + width + '" HEIGHT="'+ height +'" ');
  retVal.push('BGCOLOR="' + bgcolor + '">'+'</EMBED>\n' + '</OBJECT>');
  return  retVal.join("");
}

function updateFlashHTML()
{

}

function editTextAttribute(outputFilePath,selectedNode)
{
  var sizeArray = SWFFile.getNaturalSize(outputFilePath);
  var bgcolor = document.bgColorField.value;
  var width = Math.round(sizeArray[0]*WIDTH_PERCENT);
  var height = Math.round(sizeArray[1]*HEIGHT_PERCENT) ;
  var tagsToAdd = new Array();
//  alert (width + " " + height);
  var theLink = TEXT_URL.value;
  var docRelURL = absoluteToRelativeURL(outputFilePath, FILE_CURRENT_DOC_PATH,true);
  if (outputFilePath != REEDIT_SWF_PATH)
  {
    setFlashAttribute("PARAM","MOVIE",docRelURL,selectedNode,tagsToAdd);
    setFlashAttribute("EMBED","SRC",docRelURL,selectedNode);
  }
  setFlashAttribute("OBJECT","WIDTH",width,selectedNode);
  setFlashAttribute("OBJECT","HEIGHT",height,selectedNode);
  setFlashAttribute("EMBED","WIDTH",width,selectedNode);
  setFlashAttribute("EMBED","HEIGHT",height,selectedNode);
  setFlashAttribute("EMBED","BGCOLOR",bgcolor,selectedNode);
  setFlashAttribute("PARAM","BGCOLOR",bgcolor,selectedNode,tagsToAdd);
  if (isDocRel(theLink))
  {
    setFlashAttribute("PARAM","BASE",".",selectedNode,tagsToAdd);
    setFlashAttribute("EMBED","BASE",".",selectedNode);
  }
  else
  {
    setFlashAttribute("PARAM","BASE","",selectedNode,tagsToAdd,true);
  setFlashAttribute("EMBED","BASE","",selectedNode);
  }
  if (tagsToAdd.length>0)
    selectedNode.innerHTML = tagsToAdd.join("") + selectedNode.innerHTML;
}
